# Script AII.9.R

#Se importan los datos y se adjuntan a la memoria
datos<-read.csv2("Morfologa.csv",header=TRUE,encoding="latin1")
attach(datos)

#Se hace un panel con dos grficas, en 2 filas y 1 columna
par(mfrow=c(2,1))

#Se selecciona solo el orden Perciformes
datos1 <- datos[Orden=="Perciformes", ]

#Se realiza el histograma para la medida M2
hist(datos1$M2,breaks=length(M2),xlim=c(0,0.25),ylim=c(0,60),
main="Perciformes",xlab="",ylab="N de individuos",font.main=2,
font.lab=2,cex.main=1.25,freq=FALSE,border="grey22")

#La siguiente instruccin permite anadir una segunda serie de datos en el histograma anterior
par(new=TRUE)

#Se aade el histograma para la medida M3
hist(datos1$M3,breaks=length(M3),xlim=c(0,0.25),ylim=c(0,60),
main="",xlab="",ylab="",freq=FALSE,border="grey55")

#Se representa las funciones de porbabilidad para las medidas M2 y M3
lines(density(datos1$M2,na.rm=TRUE),lwd=2,col="red")
lines(density(datos1$M3,na.rm=TRUE),lwd=2,col="blue")

#Se aade una leyenda
legend(0.2,60,c("M2","M3"),lty=c(1,1),
lwd=c(2,2),col=c("red","blue"))

#Se repite todo el proceso en el segundo histograma del panel, pero para el orden Characiformes
datos2 <- datos[Orden=="Characiformes", ]
hist(datos2$M2,breaks=length(M2),xlim=c(0,0.25),ylim=c(0,300),main="Characiformes",
xlab="Ratio de las variables M2 y M3 frente a la longitud estndar",ylab="N de individuos",font.main=2,
font.lab=2,cex.main=1.25,freq=FALSE,border="grey22")
par(new=TRUE)
hist(datos2$M3,breaks=length(M3),xlim=c(0,0.25),ylim=c(0,300),
main="",xlab="",ylab="",freq=FALSE,border="grey55")
lines(density(datos2$M2,na.rm=TRUE),lwd=2,col="red")
lines(density(datos2$M3,na.rm=TRUE),lwd=2,col="blue")
